# Usage Guide

This guide explains how to run the system and use its features.

## Running the System

To fully utilize the system, you need to run all three components simultaneously. It is best to use three separate terminal windows.

### 1. Start Simulated Sensors & Time
This server provides the environmental data.
```bash
# In Terminal 1
cd simulated_time_and_sensor_APIs
source venv/bin/activate
python api_server.py
```
*Runs on: `http://0.0.0.0:5000`*

### 2. Start LLM Interaction Server
This server handles the "intelligence" and conversation.
```bash
# In Terminal 2
cd LLM_Interaction_APIs
source venv/bin/activate
export OPENAI_API_KEY="your-key" # If not already set
python server.py
```
*Runs on: `http://0.0.0.0:5001`*

### 3. Start Dashboard
This is your visual interface.
```bash
# In Terminal 3
cd Dashboard
source venv/bin/activate
python app.py
```
*Runs on: `http://0.0.0.0:5002`*

---

## Interaction Guide

### Dashboard Interface
Open your browser and go to `http://localhost:5002`.

- **Monitoring**: You will see real-time updates for:
    - **Temperature & Humidity**: Simulated values from the sensor API.
    - **Earth & Mars Time**: Synchronized clocks.
- **Conversation History**: The chat log between the Astronaut (User) and the Companion Bot (System) is displayed here.

### Audio Features
- **TTS (Text-to-Speech)**: New messages are automatically read aloud.
- **Mute Toggle**: Use the speaker icon/button to mute or unmute audio playback.

### Sensor Simulation
The sensor values are simulated to fluctuate naturally around a set point. They will update automatically on the dashboard without needing to refresh the page.

### Sending Data (Webhook)
The system expects data from an ESP32 (or simulated by the sensor API). The Dashboard listens for updates and the LLM Server processes them.
- **Normal Flow**: The generic sensor API (`api_server.py`) generates data -> Dashboard displays it -> LLM Server uses it for context in replies.
